<?php
// fix_db.php
// Run this file ONCE from your browser to fix the Bangla issue.

include 'db_connect.php'; 

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// 1. Force the connection to understand Bangla
$conn->set_charset("utf8mb4");

// 2. Update the table to support Bangla (UTF8MB4)
$sql = "ALTER TABLE notifications CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci";

if ($conn->query($sql) === TRUE) {
    echo "<h1>SUCCESS! ✅</h1>";
    echo "<h3>Your database is now updated to support Bangla/English.</h3>";
    echo "<p>You can now delete this file and try sending a notification.</p>";
} else {
    echo "<h1>ERROR ❌</h1>";
    echo "<h3>Could not update table: " . $conn->error . "</h3>";
}

$conn->close();
?>