<?php
header('Content-Type: application/json');

// --- 1. INCLUDE DATABASE CONNECTION ---
// This file provides both $conn (MySQLi) and $pdo (PDO)
require_once 'db_connect.php'; 

// --- 2. FETCH REVIEWS WITH JOINS ---
// We use $conn here to maintain your existing MySQLi logic
$sql = "SELECT 
            r.id,
            p.name AS product_name, 
            u.name AS user_name, 
            r.rating, 
            r.comment, 
            r.status 
        FROM reviews AS r
        LEFT JOIN products AS p ON r.product_id = p.id
        LEFT JOIN users AS u ON r.user_id = u.id
        ORDER BY r.created_at DESC";

$result = $conn->query($sql);

$reviews = array();
if ($result && $result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $reviews[] = $row;
    }
}

// --- 3. OUTPUT JSON ---
echo json_encode($reviews);

// --- 4. CLOSE CONNECTION ---
$conn->close();
?>