<?php
// update_brand.php
require_once 'db_connect.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    // Receive data from Android ApiInterface
    $id = isset($_POST['id']) ? $_POST['id'] : 0;
    $name = isset($_POST['name']) ? $_POST['name'] : '';
    $imagePath = isset($_POST['image_path']) ? $_POST['image_path'] : '';

    if (!empty($id) && !empty($name)) {
        // SQL matches your specific columns: name and image_url
        $sql = "UPDATE brands SET name = ?, image_url = ? WHERE id = ?";
        
        if ($stmt = $conn->prepare($sql)) {
            // Bind parameters (String, String, Integer)
            $stmt->bind_param("ssi", $name, $imagePath, $id);
            
            if ($stmt->execute()) {
                echo json_encode(array("status" => "success", "message" => "Brand updated successfully"));
            } else {
                echo json_encode(array("status" => "error", "message" => "SQL Error: " . $stmt->error));
            }
            $stmt->close();
        } else {
            echo json_encode(array("status" => "error", "message" => "Prepare Error: " . $conn->error));
        }
    } else {
        echo json_encode(array("status" => "error", "message" => "Required data missing (id, name, or image_path)"));
    }
} else {
    echo json_encode(array("status" => "error", "message" => "Invalid request method"));
}
$conn->close();
?>