<?php
require 'db_connect.php';

$title = isset($_POST['title']) ? $_POST['title'] : '';
$message = isset($_POST['message']) ? $_POST['message'] : '';
$imageUrl = isset($_POST['image_url']) ? $_POST['image_url'] : NULL;

$response = array();

if (empty($title) || empty($message)) {
    $response['status'] = 'error';
    $response['message'] = 'Title and message are required.';
} else {
    $stmt = $conn->prepare("INSERT INTO notifications (title, message, image_url) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $title, $message, $imageUrl);

    if ($stmt->execute()) {
        $response['status'] = 'success';
        $response['message'] = 'Notification added successfully.';
    } else {
        $response['status'] = 'error';
        $response['message'] = 'Failed to add notification: ' . $stmt->error;
    }
    $stmt->close();
}

header('Content-Type: application/json');
echo json_encode($response);

$conn->close();
?>
