<?php
// add_product.php (FINAL - with is_featured)

// This catches any accidental whitespace or included file output
ob_start();

// --- Step 1: Configure Error Handling ---
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

// Include the database connection
require 'db_connect.php'; 

// Set the header
header('Content-Type: application/json');
$response = [];

// Clear the buffer to remove any whitespace outputted by included files
ob_clean(); 

// --- Step 2: Validate the Environment ---
if (!isset($conn) || $conn->connect_error) {
    http_response_code(500);
    $response['status'] = 'error';
    $response['message'] = 'Server Error: Database connection is not available.';
    echo json_encode($response);
    exit; 
}

// --- Step 3: Validate Incoming Data ---
$required_fields = ['name', 'category', 'brand_id', 'models', 'description', 'specification', 'regular_price', 'offer_price', 'image_path'];
foreach ($required_fields as $field) {
    if (!isset($_POST[$field]) || trim($_POST[$field]) === '') {
        http_response_code(400); 
        $response['status'] = 'error';
        $response['message'] = "Required field '{$field}' is missing or empty.";
        echo json_encode($response);
        exit;
    }
}

// --- Step 4: Assign and Sanitize Data ---
$name = trim($_POST['name']);
$category = trim($_POST['category']);
$brand_id = (int)$_POST['brand_id'];
$models = trim($_POST['models']);
$description = trim($_POST['description']);
$specification = trim($_POST['specification']);
$regular_price = (float)$_POST['regular_price'];
$offer_price = (float)$_POST['offer_price'];
$image_path = trim($_POST['image_path']); 
$gallery_images = isset($_POST['gallery_images']) ? trim($_POST['gallery_images']) : ''; 
// --- NEW: Handle the 'is_featured' flag ---
$is_featured = isset($_POST['is_featured']) ? (int)$_POST['is_featured'] : 0;

// --- Step 5: Prepare and Execute Database INSERT ---
// UPDATED: Added 'is_featured' to the INSERT statement
$sql = "INSERT INTO products (name, category, brand_id, models, description, specification, regular_price, offer_price, image_url, gallery_images, is_featured) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

$stmt = $conn->prepare($sql);

if ($stmt) {
    // UPDATED: Added 'i' for the integer 'is_featured' flag
    $stmt->bind_param(
        "ssisssddssi", 
        $name, 
        $category, 
        $brand_id, 
        $models, 
        $description, 
        $specification, 
        $regular_price, 
        $offer_price, 
        $image_path,
        $gallery_images,
        $is_featured // --- NEW ---
    );

    if ($stmt->execute()) {
        $response['status'] = 'success';
        $response['message'] = 'Product added successfully.';
    } else {
        http_response_code(500);
        $response['status'] = 'error';
        $response['message'] = 'Server Error: Could not save the product.';
    }
    $stmt->close();
} else {
    http_response_code(500);
    $response['status'] = 'error';
    $response['message'] = 'Server Error: Could not prepare the database statement.';
}

// --- Final Step: Clean Output and Send JSON ---
$json_output = json_encode($response);

// Discard anything in the buffer (warnings, spaces) that happened during execution
ob_clean(); 

// Send only the JSON
echo $json_output;

$conn->close();
exit; 
?>