<?php
// add_promo_banner.php

header('Content-Type: application/json');
require 'db_connect.php';

$response = ['status' => 'error', 'message' => 'Invalid request.'];

if (isset($_POST['image_url'])) {
    $imageUrl = $_POST['image_url'];

    // Clear any existing banner to ensure only one exists
    $conn->query("DELETE FROM promo_banner");

    $sql = "INSERT INTO promo_banner (image_url) VALUES (?)";
    $stmt = $conn->prepare($sql);

    if ($stmt) {
        $stmt->bind_param("s", $imageUrl);
        
        if ($stmt->execute()) {
            $response['status'] = 'success';
            $response['message'] = 'Promotional banner updated successfully.';
        } else {
            $response['message'] = 'Database error: Failed to insert new banner. ' . $stmt->error;
        }
        $stmt->close();
    } else {
        $response['message'] = 'Database error: Could not prepare statement. ' . $conn->error;
    }
} else {
    $response['message'] = "Required 'image_url' field is missing from the request.";
}

echo json_encode($response);
$conn->close();
?>
