<?php
// --- User Password Diagnostic Script ---

// Include your database connection
require 'db_connect.php';

// Check if a user ID was provided in the URL
if (!isset($_GET['user_id']) || empty($_GET['user_id'])) {
    die("<h1>Error</h1><p>Please provide a user ID in the URL. Example: check_user.php?user_id=3</p>");
}

$userId = intval($_GET['user_id']);

echo "<h1>Checking User ID: " . htmlspecialchars($userId) . "</h1>";

try {
    $sql = "SELECT name, mobile, password FROM users WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $userId);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();

    if ($user) {
        $password_from_db = $user['password'];
        
        echo "<p><strong>Name:</strong> " . htmlspecialchars($user['name']) . "</p>";
        echo "<p><strong>Mobile:</strong> " . htmlspecialchars($user['mobile']) . "</p>";
        echo "<hr>";
        echo "<p><strong>Password value from database:</strong></p>";
        echo "<pre style='background:#f0f0f0; padding:10px; border:1px solid #ccc;'>" . htmlspecialchars($password_from_db) . "</pre>";
        echo "<hr>";

        // Check if the stored password looks like a valid hash
        $info = password_get_info($password_from_db);
        if ($info['algoName'] !== 'unknown') {
            echo "<p style='color:green; font-weight:bold;'>✅ SUCCESS: The password for this user is correctly hashed.</p>";
        } else {
            echo "<p style='color:red; font-weight:bold;'>❌ FAILED: The password for this user is stored as plain text. This is why the 'change password' feature is failing.</p>";
            echo "<p><strong>Solution:</strong> You must register a NEW account in the app to create a user with a correctly hashed password, then test the password change feature with that new account.</p>";
        }
    } else {
        echo "<p style='color:red;'>ERROR: No user found with ID: " . htmlspecialchars($userId) . "</p>";
    }

} catch (Exception $e) {
    echo "<p style='color:red;'>A fatal error occurred: " . $e->getMessage() . "</p>";
}

$conn->close();
?>