<?php
// get_categories.php - Fetches all categories using centralized connection

// --- SETUP: ENABLE ERROR REPORTING & SET HEADER ---
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');

// --- 1. & 2. INCLUDE DATABASE CONNECTION ---
// This file provides the $pdo object
require_once 'db_connect.php'; 

try {
    // --- 3. FETCH DATA ---
    // Fetch all categories, ordering by name alphabetically
    $stmt = $pdo->query("SELECT id, name, image_url FROM categories ORDER BY name ASC");
    $categories = $stmt->fetchAll();

    // Return the categories as a JSON array
    echo json_encode($categories);

} catch (PDOException $e) {
    // If a DB error occurs, return an empty JSON array to prevent app crashes.
    echo json_encode([]);
}
?>