<?php
require_once 'db_connect.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = $_POST['name'] ?? '';
    $district = $_POST['district'] ?? '';
    $phone = $_POST['phone'] ?? '';
    $address = $_POST['address'] ?? '';
    $website = $_POST['website'] ?? '';

    if (!empty($name) && !empty($district) && !empty($phone) && !empty($address)) {
        $sql = "INSERT INTO dealers (name, district, phone, address, website) VALUES (?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sssss", $name, $district, $phone, $address, $website);

        if ($stmt->execute()) {
            echo json_encode(["status" => "success", "message" => "Dealer added successfully"]);
        } else {
            echo json_encode(["status" => "error", "message" => "Database error: " . $stmt->error]);
        }
        $stmt->close();
    } else {
        echo json_encode(["status" => "error", "message" => "Missing required fields"]);
    }
}
$conn->close();
?>