<?php
// get_product_details.php (FINAL - HIGH-PERFORMANCE VERSION)

ob_start();
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);require 'db_connect.php'; 

header('Content-Type: application/json');
ob_clean();

$response = [];
$user_role = isset($_GET['user_role']) ? $_GET['user_role'] : 'user';

if (!isset($conn) || $conn->connect_error) {
    http_response_code(500);
    $response['status'] = 'error';
    $response['message'] = 'Server Error: Database connection is not available.';
    echo json_encode($response);
    exit;
}

if (!isset($_GET['id']) || empty($_GET['id'])) {
    http_response_code(400); 
    $response['status'] = 'error';
    $response['message'] = 'Product ID is missing.';
    echo json_encode($response);
    exit;
}

$product_id = intval($_GET['id']);

try {
    // --- Step 1: Fetch the main product ---
    $active_clause = ($user_role !== 'admin') ? " AND is_active = 1" : "";
    $stmt = $conn->prepare("SELECT * FROM products WHERE id = ? $active_clause");
    $stmt->bind_param("i", $product_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $product = $result->fetch_assoc();

        // --- Step 2: Fetch Brand Name ---
        if (!empty($product['brand_id'])) {
            $brand_stmt = $conn->prepare("SELECT name FROM brands WHERE id = ?");
            $brand_stmt->bind_param("i", $product['brand_id']);
            $brand_stmt->execute();
            $brand_result = $brand_stmt->get_result();
            if($brand_row = $brand_result->fetch_assoc()){
                $product['brand_name'] = $brand_row['name'];
            }
        }

        // --- Step 3: Fetch Reviews and Calculate Ratings ---
        $reviews = [];
        $total_rating = 0;
        $review_count = 0;
        
        $review_stmt = $conn->prepare("SELECT * FROM reviews WHERE product_id = ? AND status = 'Published'");
        $review_stmt->bind_param("i", $product_id);
        $review_stmt->execute();
        $review_result = $review_stmt->get_result();

        while($review_row = $review_result->fetch_assoc()){
            $reviews[] = $review_row;
            $total_rating += $review_row['rating'];
            $review_count++;
        }

        $product['reviews'] = $reviews;
        $product['total_reviews'] = $review_count;
        $product['rating'] = ($review_count > 0) ? ($total_rating / $review_count) : 0;
        
        // --- Final Step: Send the complete product object ---
        echo json_encode($product, JSON_UNESCAPED_UNICODE | JSON_NUMERIC_CHECK);

    } else {
        http_response_code(404);
        $response['status'] = 'error';
        $response['message'] = 'Product not found or is not active.';
        echo json_encode($response);
    }
    
    $stmt->close();

} catch (Exception $e) {
    http_response_code(500);
    $response['status'] = 'error';
    $response['message'] = 'Server Error: ' . $e->getMessage();
    echo json_encode($response);
}

$conn->close();
exit;
?>